 /**
 * jQuery emgPag v0.7
 * Client side pagination with jQuery
 * http://luis-almeida.github.com/emgPag
 *
 * Licensed under the MIT license.
 * Copyright 2012 Luís Almeida
 * https://github.com/luis-almeida
 */
 
(function(e,t,n,r){function u(r,i){this.options=e.extend({},o,i);this._container=e("."+this.options.containerID);if(!this._container.length)return;this.jQwindow=e(t);this.jQdocument=e(n);this._holder=e(r);this._nav={};this._first=e(this.options.first);this._previous=e(this.options.previous);this._next=e(this.options.next);this._last=e(this.options.last);this._items=this._container.children(":visible");this._itemsShowing=e([]);this._itemsHiding=e([]);this._numPages=Math.ceil(jQuery(".peasyitem:visible").size()/this.options.perPage);this._currentPageNum=this.options.startPage;this._clicked=false;this._cssAnimSupport=this.getCSSAnimationSupport();this.init()}var i="emgPag",s=null,o={containerID:"",first:false,previous:"« prev",next:"next »",last:false,links:"numeric",startPage:1,perPage:10,midRange:5,startRange:1,endRange:1,keyBrowse:true,scrollBrowse:false,pause:0,clickStop:false,delay:50,direction:"forward",animation:"",fallback:400,minHeight:true,callback:r};u.prototype={constructor:u,getCSSAnimationSupport:function(){var e=false,t="animation",n="",i="Webkit Moz O ms Khtml".split(" "),s="",o=this._container.get(0);if(o.style.animationName)e=true;if(e===false){for(var u=0;u<i.length;u++){if(o.style[i[u]+"AnimationName"]!==r){s=i[u];t=s+"Animation";n="-"+s.toLowerCase()+"-";e=true;break}}}return e},init:function(){this.setStyles();this.setNav();this.paginate(this._currentPageNum);this.setMinHeight()},setStyles:function(){var t="<style>"+".jp-invisible { visibility: hidden !important; } "+".jp-hidden { display: none !important; }"+"</style>";e(t).appendTo("head");if(this._cssAnimSupport&&this.options.animation.length)this._items.addClass("animated jp-hidden");else this._items.hide()},setNav:function(){var t=this.writeNav();this._holder.each(this.bind(function(n,r){var i=e(r);i.html(t);this.cacheNavElements(i,n);this.bindNavHandlers(n);this.disableNavSelection(r)},this));if(this.options.keyBrowse)this.bindNavKeyBrowse();if(this.options.scrollBrowse)this.bindNavScrollBrowse()},writeNav:function(){var e=1,t;t=this.writeBtn("first")+this.writeBtn("previous");for(;e<=this._numPages;e++){if(e===1&&this.options.startRange===0)t+="<span>...</span>";if(e>this.options.startRange&&e<=this._numPages-this.options.endRange)t+="<a href='#' class='jp-hidden'>";else t+="<a>";switch(this.options.links){case"numeric":t+=e;break;case"blank":break;case"title":var n=this._items.eq(e-1).attr("data-title");t+=n!==r?n:"";break}t+="</a>";if(e===this.options.startRange||e===this._numPages-this.options.endRange)t+="<span>...</span>"}t+=this.writeBtn("next")+this.writeBtn("last")+"</div>";return t},writeBtn:function(t){return this.options[t]!==false&&!e(this["_"+t]).length?"<a class='jp-"+t+"'>"+this.options[t]+"</a>":""},cacheNavElements:function(t,n){this._nav[n]={};this._nav[n].holder=t;this._nav[n].first=this._first.length?this._first:this._nav[n].holder.find("a.jp-first");this._nav[n].previous=this._previous.length?this._previous:this._nav[n].holder.find("a.jp-previous");this._nav[n].next=this._next.length?this._next:this._nav[n].holder.find("a.jp-next");this._nav[n].last=this._last.length?this._last:this._nav[n].holder.find("a.jp-last");this._nav[n].fstBreak=this._nav[n].holder.find("span:first");this._nav[n].lstBreak=this._nav[n].holder.find("span:last");this._nav[n].pages=this._nav[n].holder.find("a").not(".jp-first, .jp-previous, .jp-next, .jp-last");this._nav[n].permPages=this._nav[n].pages.slice(0,this.options.startRange).add(this._nav[n].pages.slice(this._numPages-this.options.endRange,this._numPages));this._nav[n].pagesShowing=e([]);this._nav[n].currentPage=e([])},bindNavHandlers:function(t){var n=this._nav[t];n.holder.bind("click.emgPag",this.bind(function(t){var r=this.getNewPage(n,e(t.target));if(this.validNewPage(r)){this._clicked=true;this.paginate(r)}t.preventDefault()},this));if(this._first.length){this._first.bind("click.emgPag",this.bind(function(){if(this.validNewPage(1)){this._clicked=true;this.paginate(1)}},this))}if(this._previous.length){this._previous.bind("click.emgPag",this.bind(function(){var e=this._currentPageNum-1;if(this.validNewPage(e)){this._clicked=true;this.paginate(e)}},this))}if(this._next.length){this._next.bind("click.emgPag",this.bind(function(){var e=this._currentPageNum+1;if(this.validNewPage(e)){this._clicked=true;this.paginate(e)}},this))}if(this._last.length){this._last.bind("click.emgPag",this.bind(function(){if(this.validNewPage(this._numPages)){this._clicked=true;this.paginate(this._numPages)}},this))}},disableNavSelection:function(e){if(typeof e.onselectstart!="undefined")e.onselectstart=function(){return false};else if(typeof e.style.MozUserSelect!="undefined")e.style.MozUserSelect="none";else e.onmousedown=function(){return false}},bindNavKeyBrowse:function(){this.jQdocument.bind("keydown.emgPag",this.bind(function(e){var t=e.target.nodeName.toLowerCase();if(this.elemScrolledIntoView()&&t!=="input"&&t!="textarea"){var n=this._currentPageNum;if(e.which==37)n=this._currentPageNum-1;if(e.which==39)n=this._currentPageNum+1;if(this.validNewPage(n)){this._clicked=true;this.paginate(n)}}},this))},elemScrolledIntoView:function(){var e,t,n,r;e=this.jQwindow.scrollTop();t=e+this.jQwindow.height();n=this._container.offset().top;r=n+this._container.height();return r>=e&&n<=t},bindNavScrollBrowse:function(){this._container.bind("mousewheel.emgPag DOMMouseScroll.emgPag",this.bind(function(e){var t=(e.originalEvent.wheelDelta||-e.originalEvent.detail)>0?this._currentPageNum-1:this._currentPageNum+1;if(this.validNewPage(t)){this._clicked=true;this.paginate(t)}e.preventDefault();return false},this))},getNewPage:function(e,t){if(t.is(e.currentPage))return this._currentPageNum;if(t.is(e.pages))return e.pages.index(t)+1;if(t.is(e.first))return 1;if(t.is(e.last))return this._numPages;if(t.is(e.previous))return e.pages.index(e.currentPage);if(t.is(e.next))return e.pages.index(e.currentPage)+2},validNewPage:function(e){return e!==this._currentPageNum&&e>0&&e<=this._numPages},paginate:function(t){var n,r;n=this.updateItems(t);r=this.updatePages(t);this._currentPageNum=t;if(e.isFunction(this.options.callback))this.callback(t,n,r);this.updatePause()},updateItems:function(e){var t=this.getItemRange(e);this._itemsHiding=this._itemsShowing;this._itemsShowing=this._items.slice(t.start,t.end);if(this._cssAnimSupport&&this.options.animation.length)this.cssAnimations(e);else this.jQAnimations(e);return t},getItemRange:function(e){var t={};t.start=(e-1)*this.options.perPage;t.end=t.start+this.options.perPage;if(t.end>this._items.length)t.end=this._items.length;return t},cssAnimations:function(e){clearInterval(this._delay);this._itemsHiding.removeClass(this.options.animation+" jp-invisible").addClass("jp-hidden");this._itemsShowing.removeClass("jp-hidden").addClass("jp-invisible");this._itemsOriented=this.getDirectedItems(e);this._index=0;this._delay=setInterval(this.bind(function(){if(this._index===this._itemsOriented.length)clearInterval(this._delay);else{this._itemsOriented.eq(this._index).removeClass("jp-invisible").addClass(this.options.animation)}this._index=this._index+1},this),this.options.delay)},jQAnimations:function(e){clearInterval(this._delay);this._itemsHiding.addClass("jp-hidden");this._itemsShowing.fadeTo(0,0).removeClass("jp-hidden");this._itemsOriented=this.getDirectedItems(e);this._index=0;this._delay=setInterval(this.bind(function(){if(this._index===this._itemsOriented.length)clearInterval(this._delay);else{this._itemsOriented.eq(this._index).fadeTo(this.options.fallback,1)}this._index=this._index+1},this),this.options.delay)},getDirectedItems:function(t){var n;switch(this.options.direction){case"backwards":n=e(this._itemsShowing.get().reverse());break;case"random":n=e(this._itemsShowing.get().sort(function(){return Math.round(Math.random())-.5}));break;case"auto":n=t>=this._currentPageNum?this._itemsShowing:e(this._itemsShowing.get().reverse());break;default:n=this._itemsShowing}return n},updatePages:function(e){var t,n,r;t=this.getInterval(e);for(n in this._nav){if(this._nav.hasOwnProperty(n)){r=this._nav[n];this.updateBtns(r,e);this.updateCurrentPage(r,e);this.updatePagesShowing(r,t);this.updateBreaks(r,t)}}return t},getInterval:function(e){var t,n,r,i;t=Math.ceil(this.options.midRange/2);n=this._numPages-this.options.midRange;r=e>t?Math.max(Math.min(e-t,n),0):0;i=e>t?Math.min(e+t-(this.options.midRange%2>0?1:0),this._numPages):Math.min(this.options.midRange,this._numPages);return{start:r,end:i}},updateBtns:function(e,t){if(t===1){e.first.addClass("jp-disabled");e.previous.addClass("jp-disabled")}if(t===this._numPages){e.next.addClass("jp-disabled");e.last.addClass("jp-disabled")}if(this._currentPageNum===1&&t>1){e.first.removeClass("jp-disabled");e.previous.removeClass("jp-disabled")}if(this._currentPageNum===this._numPages&&t<this._numPages){e.next.removeClass("jp-disabled");e.last.removeClass("jp-disabled")}},updateCurrentPage:function(e,t){e.currentPage.removeClass("jp-current");e.currentPage=e.pages.eq(t-1).addClass("jp-current")},updatePagesShowing:function(e,t){var n=e.pages.slice(t.start,t.end).not(e.permPages);e.pagesShowing.not(n).addClass("jp-hidden");n.not(e.pagesShowing).removeClass("jp-hidden");e.pagesShowing=n},updateBreaks:function(e,t){if(t.start>this.options.startRange||this.options.startRange===0&&t.start>0)e.fstBreak.removeClass("jp-hidden");else e.fstBreak.addClass("jp-hidden");if(t.end<this._numPages-this.options.endRange)e.lstBreak.removeClass("jp-hidden");else e.lstBreak.addClass("jp-hidden")},callback:function(e,t,n){var r={current:e,interval:n,count:this._numPages},i={showing:this._itemsShowing,oncoming:this._items.slice(t.start+this.options.perPage,t.end+this.options.perPage),range:t,count:this._items.length};r.interval.start=r.interval.start+1;i.range.start=i.range.start+1;this.options.callback(r,i)},updatePause:function(){if(this.options.pause&&this._numPages>1){clearTimeout(this._pause);if(this.options.clickStop&&this._clicked)return;else{this._pause=setTimeout(this.bind(function(){this.paginate(this._currentPageNum!==this._numPages?this._currentPageNum+1:1)},this),this.options.pause)}}},setMinHeight:function(){if(this.options.minHeight&&!this._container.is("table, tbody")){setTimeout(this.bind(function(){this._container.css({"min-height":this._container.css("height")})},this),1e3)}},bind:function(e,t){return function(){return e.apply(t,arguments)}},destroy:function(){this.jQdocument.unbind("keydown.emgPag");this._container.unbind("mousewheel.emgPag DOMMouseScroll.emgPag");if(this.options.minHeight)this._container.css("min-height","");if(this._cssAnimSupport&&this.options.animation.length)this._items.removeClass("animated jp-hidden jp-invisible "+this.options.animation);else this._items.removeClass("jp-hidden").fadeTo(0,1);this._holder.unbind("click.emgPag").empty()}};e.fn[i]=function(t){var n=e.type(t);if(n==="object"){if(this.length&&!e.data(this,i)){s=new u(this,t);this.each(function(){e.data(this,i,s)})}return this}if(n==="string"&&t==="destroy"){s.destroy();this.each(function(){e.removeData(this,i)});return this}if(n==="number"&&t%1===0){if(s.validNewPage(t))s.paginate(t);return this}return this}})(jQuery,window,document)